//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 17:09:36 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: pendulum_spring_c
//
//	==> Number of joints: 4
//
//	==> Function: F7 - Link Forces (1D)
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"

#include "mbs_project_interface.h"

void mbs_link(double **frc, double **trq, double *Flink, double *Z, double *Zd,
MbsData *s, double tsim)
{
#include "mbs_link_pendulum_spring_c.h"

double *q, *qd;
double **l, **dpt;

frc = s->frc;
trq = s->trq;
Z = s->Z;
Zd = s->Zd;

q = s->q;
qd = s->qd;

dpt = s->dpt;
l  = s->l;
 
// Trigonometric functions

S1 = sin(q[1]);
C1 = cos(q[1]);
 
// Augmented Joint Position Vectors

Dz23 = q[2]+dpt[3][3];
 
// Augmented Joint Position Vectors

 
// Link anchor points Kinematics

RLlnk2_12 = dpt[3][4]*S1;
RLlnk2_32 = dpt[3][4]*C1;
ORlnk2_12 = qd[1]*RLlnk2_32;
ORlnk2_32 = -qd[1]*RLlnk2_12;
Plnk11 = RLlnk2_12-dpt[1][1];
PPlnk1 = Plnk11*Plnk11+RLlnk2_32*RLlnk2_32;
Z1 = sqrt(PPlnk1);
e11 = Plnk11/Z1;
e31 = RLlnk2_32/Z1;
Zd1 = ORlnk2_12*e11+ORlnk2_32*e31;

// Link Forces 

Flink1 = user_call_LinkForces(Z1,Zd1,s,tsim,1);
 
// Link Dynamics: forces projection on body-fixed frames

fSlnk11 = Flink1*(e11*C1-e31*S1);
fSlnk31 = Flink1*(e11*S1+e31*C1);
trqlnk1_1_2 = -fSlnk11*(dpt[3][4]-l[3][1]);
 
// Symbolic model output

frc[1][1] = frc[1][1]-fSlnk11;
frc[3][1] = frc[3][1]-fSlnk31;
trq[2][1] = trq[2][1]+trqlnk1_1_2;
 
// Symbolic model output

Z[1] = Z1;
Zd[1] = Zd1;
Flink[1] = Flink1;

// Number of continuation lines = 0

}
